/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/


#ifndef __FUNCHEADER_H__

#define __FUNCHEADER_H__

#define __CCLIENT__

#include "../../C/include/CUtility.h"

#define CONV_SUCCESS 0
#define CONV_FAILURE -1

//Helm declarations
HRESULT GetHelmProDESKTOP();
HRESULT CommitToProDESKTOP(CString str,BOOL bl = FALSE);
HRESULT ReleaseHelmProDESKTOP();

//Drawing declarations
HRESULT TestDrawingAngularCF() ;
HRESULT TestDrawingDatumCF() ;
HRESULT TestDrawingNoteCF() ;
HRESULT TestDrawingGeomTolCF() ;
HRESULT TestDrawingRadialCF() ;
HRESULT TestDrawingLinearCF() ;
HRESULT TestDrawingDiametricCF() ;

// some simple models 
HRESULT CreateCone() ;
HRESULT CreateCylinder() ;
HRESULT RectangularBlock() ;
HRESULT Torous() ;
HRESULT Spindle(CString filename = "", BOOL saveFlag = FALSE) ;
HRESULT Wheel(CString filename = "", BOOL saveFlag = FALSE) ;
HRESULT DrawCircle() ;
HRESULT DrawRectangle() ;
HRESULT GearDesign() ;


HRESULT TestNewPart() ;	
HRESULT TestNewDrawing() ;


// Demo
HRESULT DemoSpindleWheelAssembly() ; 

// Assembly Conv function
HRESULT centerAxesPrior() ;
HRESULT AlignPlanesPrior() ;
HRESULT MatePlanesPrior() ;
HRESULT OrientAxesPrior() ;



// Axes conv functions
HRESULT TestReverseAxes() ;
HRESULT TestRotateAxes();
HRESULT TestTranslateAxes();
HRESULT TestRepositionAxes();

// Workplanes related conv functions
HRESULT TestPlaneOfObject() ;
HRESULT TestOrientedplane() ;
HRESULT TestPlaneThroughObjects() ;
HRESULT TestOffsetplane() ;
HRESULT TestMidplane() ;
HRESULT TestNewSketch() ;
HRESULT TestHideOtherSketches() ;


// Feature related conv functions
HRESULT TestSimpleBlend() ;
HRESULT TestVariableBlend() ;
HRESULT TestHollow() ;
HRESULT  TestUseComponent() ;
HRESULT  TestUncondemnAll() ;
HRESULT TestExtrusion() ;
HRESULT TestRevolutionToDrawCone() ;
HRESULT TestHole() ;
HRESULT TestProjection() ;
HRESULT TestSweepToDrawPrism() ;


// Line Convenience Functions

// Line Convenience Input Functions

HRESULT GetCreateLineInput(double *startX, double *startY, double *endX, double *endY) ;

HRESULT GetCreateCircleInput(double *centerX, double *centerY, double *radius) ;

HRESULT GetCreateRectangleInput(double *startX, double *startY,
								double *endX, double *endY) ;

HRESULT GetCreateArcStartEndCenterInput(IPoint **startPoint, IPoint **endPoint,
										IPoint **centerPoint) ;




// Edit Convenience Functions


// Edit Convenience Input Functions

HRESULT GetDeleteLinesInput(ISet **objectSet1) ;

HRESULT GetOffsetChainInput(ISet **objectSet1, double *offsetDistance, long *offsetDirection) ;

HRESULT GetTranslateObjectsInput(double *xDistance, double *yDistance,
								 ISet **objectset1) ;

HRESULT GetRotateObjectsInput(double *angle, ISet **objectset1) ;

HRESULT GetScaleObjectsInput(double *scaleFactor, ISet **objectset1) ;

HRESULT GetRectangularDuplicateInput(double *xNumber, double *yNumber,
									 double *xSpacing, double *ySpacing,
									 ISet **objectSet1) ;

HRESULT GetCircularDuplicateInput(long *number, double *angle, BOOL *isTotalAngle,
								  ISet **objectSet1) ;

HRESULT GetMirrorInXInput(ISet **objectSet1) ;

HRESULT GetMirrorInYInput(ISet **objectSet1) ;

HRESULT GetMirrorInBothInput(ISet **objectSet1) ;




// Constraints Convenience Methods


// Constraints Convenience Input Functions

HRESULT GetMakeParallelInput(ISet **objectSet) ;

HRESULT GetMakePerpendicularInput(ILine **line1, ILine **line2) ;

HRESULT GetMakeColinearInput(ISet **objectSet) ;

HRESULT GetMakeTangentLineCircleInput(ILine **line1, ILine **circle1) ;

HRESULT GetMakeTangentCircleCircleInput(ILine **circle1, ILine **circle2) ;

HRESULT GetMakeConcentricInput(ISet **objectSet) ;

HRESULT GetMakeEqualLengthInput(ISet **objectSet) ;

HRESULT GetMakeEqualRadiusInput(ISet **objectSet) ;

HRESULT GetFixLineInput(ISet **objectSet) ;

HRESULT GetConstrainSizeInput(ILine **line) ;

HRESULT GetConstrainSeparationPointToPointInput(IPoint **point1,
												IPoint **point2) ;

HRESULT GetConstrainSeparationPointToLineInput(IPoint **point1, ILine **line1) ;

HRESULT GetConstrainSeparationLineToLineInput(ILine **line1, ILine **line2) ;

HRESULT GetMakeRadialDimInput(ILine **circle1) ;

HRESULT GetMakeAngularDimInput(ILine **line1, ILine **line2) ;

HRESULT GetRemoveConstraintsInput(ISet **objectSet, long *nature) ;




// Create Line Convenience Functions


// Create Line Convenience Input Functions

HRESULT GetCreateLineLineInput(ILine **line1, ILine **line2) ;

HRESULT GetCreateCircleLineInput(ILine **circle1, ILine **line1) ;

HRESULT GetCreateLineCircleInput(ILine **line1, ILine **circle1) ;

HRESULT GetCreateCircleCircleInput(ILine **circle1, ILine **circle2) ;

HRESULT GetCreateLineStartToStartInput(ILine **line1, ILine **line2) ;

HRESULT GetCreateLineStartToMiddleInput(ILine **line1, ILine **line2) ;

HRESULT GetCreateLineStartToEndInput(ILine **line1, ILine **line2) ;

HRESULT GetCreateLineMiddleToStartInput(ILine **line1, ILine **line2) ;

HRESULT GetCreateLineMiddleToMiddleInput(ILine **line1, ILine **line2) ;

HRESULT GetCreateLineMiddleToEndInput(ILine **line1, ILine **line2) ;

HRESULT GetCreateLineEndToStartInput(ILine **line1, ILine **line2) ;

HRESULT GetCreateLineEndToMiddleInput(ILine **line1, ILine **line2) ;

HRESULT GetCreateLineEndToEndInput(ILine **line1, ILine **line2) ;

HRESULT GetCreateLineCenterToStartInput(ILine **circle1, ILine **line1) ;

HRESULT GetCreateLineCenterToMiddleInput(ILine **circle1, ILine **line1) ;

HRESULT GetCreateLineCenterToEndInput(ILine **circle1, ILine **line1) ;

HRESULT GetCreateLineStartToCenterInput(ILine **line1, ILine **circle1) ;

HRESULT GetCreateLineMiddleToCenterInput(ILine **line1, ILine **circle1) ;

HRESULT GetCreateLineEndToCenterInput(ILine **line1, ILine **circle1) ;

HRESULT GetCreateLineCenterToCenterInput(ILine **circle1, ILine **circle2) ;


// Miscellaneous Helper Functions


#endif

